export default ({ livewireId }) => ({
    actionNestingIndex: null,

    init() {
        window.addEventListener('sync-action-modals', (event) => {
            if (event.detail.id !== livewireId) {
                return
            }

            this.syncActionModals(event.detail.newActionNestingIndex)
        })
    },

    syncActionModals(newActionNestingIndex) {
        if (this.actionNestingIndex === newActionNestingIndex) {
            // https://github.com/filamentphp/filament/issues/16474
            this.actionNestingIndex !== null &&
                this.$nextTick(() => this.openModal())

            return
        }

        if (this.actionNestingIndex !== null) {
            this.closeModal()
        }

        this.actionNestingIndex = newActionNestingIndex

        if (this.actionNestingIndex === null) {
            return
        }

        if (
            !this.$el.querySelector(
                `#${this.generateModalId(newActionNestingIndex)}`,
            )
        ) {
            this.$nextTick(() => this.openModal())

            return
        }

        this.openModal()
    },

    generateModalId(actionNestingIndex) {
        // HTML IDs must start with a letter, so if the Livewire component ID starts
        // with a number, we need to make sure it does not fail by prepending `fi-`.
        return `fi-${livewireId}-action-` + actionNestingIndex
    },

    openModal() {
        const id = this.generateModalId(this.actionNestingIndex)

        this.$dispatch('open-modal', { id })
    },

    closeModal() {
        const id = this.generateModalId(this.actionNestingIndex)

        this.$dispatch('close-modal-quietly', { id })
    },
})
