<?php

namespace App\Filament\Account\Widgets;

use App\Models\Pack;
use App\Models\Subscription;
use Illuminate\Support\Facades\Auth;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Widgets\StatsOverviewWidget as BaseStatsOverviewWidget;

class StatsOverviewWidget extends BaseStatsOverviewWidget
{
    protected function getStats(): array
    {
        $pricePacks =  Subscription::where('user_id', Auth::id())
            ->with('pack') // charger la relation
            ->get()
            ->sum(fn($sub) => $sub->pack->price);

        $renewalsSoon = Subscription::where('user_id', Auth::id())
            ->where('status', 'actif')
            ->whereDate('end_date', '<=', now()->addDays(7))
            ->count();

        $reabonnements = Subscription::where('user_id', Auth::id())
            ->where('status', 'expiré')
            ->count();

        return [

            Stat::make('Abonnements actifs', Subscription::where('status', 'actif')->where('user_id', Auth::id())->count())
                ->icon('heroicon-o-bolt')
                ->color('success')
                ->description('Actuellement en cours')
                ->descriptionIcon('heroicon-o-check-circle'),

            Stat::make('Abonnements expirés', Subscription::where('status', 'expiré')->where('user_id', Auth::id())->count())
                ->icon('heroicon-o-x-circle')
                ->color('danger')
                ->description('Nécessitent un renouvellement')
                ->descriptionIcon('heroicon-o-exclamation-triangle'),

            //ENTREPRISES
            Stat::make('Montant des paiements', $pricePacks)
                ->icon('heroicon-o-wallet')
                ->color('primary')
                ->description('Total des paiements')
                ->descriptionIcon('heroicon-o-wallet'),

            Stat::make('Renouvellements à venir', $renewalsSoon)
                ->icon('heroicon-o-clock')
                ->color('warning')
                ->description('Expire bientôt'),
            //  ->descriptionIcon('heroicon-o-exclamation'),

            Stat::make('Réabonnements', $reabonnements)
                ->icon('heroicon-o-arrow-uturn-right')
                ->color('primary')
                ->description('Nombre de réabonnements')
                ->descriptionIcon('heroicon-o-check-circle'),


        ];
    }
}